# import des different composants necessaires
from vtk import *

# ------------------------------------------------
# creation de structure de donnee,i.e la grille
# ------------------------------------------------

dataset = vtkImageData()
dataset.SetDimensions(26, 26, 26) 
dataset.SetOrigin(-0.5, -0.5, -0.5)
gridStep = 1.0/25.0
dataset.SetSpacing(gridStep, gridStep, gridStep)

# creation des donnees, i.e un tableau de flottants
scalarData = vtkFloatArray()

for k in range(26):
    z = -0.5 + k*gridStep
    kOffset = k * 26 *26
    for j in range(26):
        y = -0.5 + j*gridStep
        jOffset = j * 26
        for i in range(26):
            x = -0.5 + i*gridStep
            value = x*x + y*y + z*z - (0.4*0.4)
            offset = i + jOffset + kOffset
            # ajout de la donnee au vtkFloatArray
            scalarData.InsertTuple1(offset, value)

dataset.GetPointData().SetScalars(scalarData)

# ------------------------------------------------
# fin de la creation de structure de donnee
# ------------------------------------------------
